/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.css.core.CSSCorePlugin;
import com.aptana.css.core.internal.index.CSSIndexReader;
import com.aptana.css.core.model.ElementElement;
import com.aptana.css.core.model.PropertyElement;
import com.aptana.css.core.model.PseudoClassElement;
import com.aptana.css.core.model.PseudoElementElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSIndexQueryHelper {
    private CSSIndexReader _reader = new CSSIndexReader();

    public static Index getIndex() {
        return CSSIndexQueryHelper.getIndexManager().getIndex(URI.create("css.metadata:/css"));
    }

    protected static IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    public Map<String, String> getClasses(Index index) {
        return this._reader.getValues(index, "css.class");
    }

    public Set<String> getColors(Index index) {
        Map<String, String> colorMap;
        if (index != null && (colorMap = this._reader.getValues(index, "css.color")) != null) {
            return colorMap.keySet();
        }
        return Collections.emptySet();
    }

    public ElementElement getElement(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        try {
            List<ElementElement> elements = this._reader.getElements(CSSIndexQueryHelper.getIndex(), name);
            if (!CollectionsUtil.isEmpty(elements)) {
                return elements.get(0);
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public List<ElementElement> getElements() {
        try {
            return this._reader.getElements(CSSIndexQueryHelper.getIndex());
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Map<String, String> getIDs(Index index) {
        return this._reader.getValues(index, "css.identifier");
    }

    public List<PropertyElement> getProperties() {
        try {
            return this._reader.getProperties(CSSIndexQueryHelper.getIndex());
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public PropertyElement getProperty(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        try {
            List<PropertyElement> properties = this._reader.getProperties(CSSIndexQueryHelper.getIndex(), name);
            if (!CollectionsUtil.isEmpty(properties)) {
                return properties.get(0);
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public List<PseudoClassElement> getPseudoClasses() {
        try {
            return this._reader.getPseudoClasses(CSSIndexQueryHelper.getIndex());
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public PseudoClassElement getPseudoClass(String name) {
        for (PseudoClassElement pce : this.getPseudoClasses()) {
            if (!ObjectUtil.areEqual((Object)name, (Object)pce.getName())) continue;
            return pce;
        }
        return null;
    }

    public List<PseudoElementElement> getPseudoElements() {
        try {
            return this._reader.getPseudoElements(CSSIndexQueryHelper.getIndex());
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public PseudoElementElement getPseudoElement(String name) {
        for (PseudoElementElement pee : this.getPseudoElements()) {
            if (!ObjectUtil.areEqual((Object)name, (Object)pee.getName())) continue;
            return pee;
        }
        return null;
    }
}

